/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client;

import com.google.common.base.Charsets;
import com.google.common.cache.Cache;
import com.google.gson.Gson;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.toasts.GuiToast;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.pathfinding.Path;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.internal.EntitySpawnMessageHelper;
import noppes.npcs.CustomNpcs;
import noppes.npcs.EventHooks;
import noppes.npcs.LogWriter;
import noppes.npcs.NBTTags;
import noppes.npcs.NoppesStringUtils;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.PacketHandlerServer;
import noppes.npcs.Server;
import noppes.npcs.ServerEventsHandler;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.constants.AnimationKind;
import noppes.npcs.api.handler.data.IQuest;
import noppes.npcs.api.mixin.entity.player.IEntityPlayerMixin;
import noppes.npcs.api.wrapper.ItemStackWrapper;
import noppes.npcs.client.Client;
import noppes.npcs.client.ClientEventHandler;
import noppes.npcs.client.ClientGuiEventHandler;
import noppes.npcs.client.ClientHandler;
import noppes.npcs.client.ClientProxy;
import noppes.npcs.client.ClientTickHandler;
import noppes.npcs.client.EntityUtil;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.RenderChatMessages;
import noppes.npcs.client.controllers.MusicController;
import noppes.npcs.client.gui.GuiAchievement;
import noppes.npcs.client.gui.GuiNpcMobSpawnerAdd;
import noppes.npcs.client.gui.GuiNpcRemoteEditor;
import noppes.npcs.client.gui.global.GuiNPCManageDialogs;
import noppes.npcs.client.gui.global.GuiNPCManageMarkets;
import noppes.npcs.client.gui.global.GuiNPCManageQuest;
import noppes.npcs.client.gui.player.GuiCustomChest;
import noppes.npcs.client.gui.player.GuiMailbox;
import noppes.npcs.client.gui.player.GuiMailmanWrite;
import noppes.npcs.client.gui.player.GuiNPCTrader;
import noppes.npcs.client.gui.player.GuiQuestCompletion;
import noppes.npcs.client.gui.script.GuiScriptInterface;
import noppes.npcs.client.gui.util.GuiContainerNPCInterface;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.client.gui.util.IGuiClose;
import noppes.npcs.client.gui.util.IGuiData;
import noppes.npcs.client.gui.util.IGuiError;
import noppes.npcs.client.gui.util.IScrollData;
import noppes.npcs.client.model.animation.AnimationConfig;
import noppes.npcs.client.model.animation.EmotionConfig;
import noppes.npcs.client.model.part.ModelData;
import noppes.npcs.client.renderer.MarkRenderer;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.constants.EnumPlayerPacket;
import noppes.npcs.constants.EnumRewardType;
import noppes.npcs.constants.EnumScriptType;
import noppes.npcs.constants.EnumSync;
import noppes.npcs.containers.ContainerNPCBank;
import noppes.npcs.controllers.AnimationController;
import noppes.npcs.controllers.BorderController;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.DropController;
import noppes.npcs.controllers.MarcetController;
import noppes.npcs.controllers.PlayerSkinController;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.SchematicController;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.controllers.SyncController;
import noppes.npcs.controllers.data.Dialog;
import noppes.npcs.controllers.data.DropsTemplate;
import noppes.npcs.controllers.data.Marcet;
import noppes.npcs.controllers.data.MarkData;
import noppes.npcs.controllers.data.MiniMapData;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerMail;
import noppes.npcs.controllers.data.PlayerMiniMapData;
import noppes.npcs.controllers.data.Quest;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityDialogNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.entity.data.DataAnimation;
import noppes.npcs.items.ItemScripted;
import noppes.npcs.schematics.Schematic;
import noppes.npcs.schematics.SchematicWrapper;
import noppes.npcs.util.TempFile;
import noppes.npcs.util.Util;

public class PacketHandlerClient
extends PacketHandlerServer {
    private static List<EnumPacketClient> list = new ArrayList<EnumPacketClient>();

    /*
     * WARNING - void declaration
     */
    private void client(ByteBuf buffer, EntityPlayer player, EnumPacketClient type) throws Exception {
        Minecraft mc = Minecraft.func_71410_x();
        PlayerData data = CustomNpcs.proxy.getPlayerData((EntityPlayer)mc.field_71439_g);
        if (type == EnumPacketClient.CHAT_BUBBLE) {
            Entity entity2 = mc.field_71441_e.func_73045_a(buffer.readInt());
            if (!(entity2 instanceof EntityNPCInterface) && !(entity2 instanceof EntityPlayer)) {
                return;
            }
            if (entity2 instanceof EntityNPCInterface) {
                EntityNPCInterface npc = (EntityNPCInterface)entity2;
                if (npc.messages == null) {
                    npc.messages = new RenderChatMessages();
                }
                String text = NoppesStringUtils.formatText(Server.readString(buffer), new Object[]{player, npc});
                npc.messages.addMessage(text, (Entity)npc);
                if (buffer.readBoolean()) {
                    player.func_145747_a((ITextComponent)new TextComponentString(npc.func_70005_c_() + ": " + text));
                }
                return;
            }
            if (!CustomNpcs.EnableChatBubbles || !CustomNpcs.EnablePlayerChatBubbles) {
                return;
            }
            EntityPlayer pl = (EntityPlayer)entity2;
            if (!ClientEventHandler.chatMessages.containsKey(pl)) {
                ClientEventHandler.chatMessages.put(pl, new RenderChatMessages());
            }
            ClientEventHandler.chatMessages.get(pl).addMessage(Server.readString(buffer), (Entity)pl);
        } else if (type == EnumPacketClient.CHAT) {
            String str;
            StringBuilder message = new StringBuilder();
            while ((str = Server.readString(buffer)) != null && !str.isEmpty()) {
                message.append(new TextComponentTranslation(str, new Object[0]).func_150254_d());
            }
            player.func_145747_a((ITextComponent)new TextComponentTranslation(message.toString(), new Object[0]));
        } else if (type == EnumPacketClient.EYE_BLINK) {
            Entity entity3 = mc.field_71441_e.func_73045_a(buffer.readInt());
            if (entity3 instanceof EntityNPCInterface) {
                ModelData model = ((EntityCustomNpc)entity3).modelData;
                model.eyes.blinkStart = System.currentTimeMillis();
            }
        } else if (type == EnumPacketClient.MESSAGE) {
            TextComponentTranslation title = new TextComponentTranslation(Objects.requireNonNull(Server.readString(buffer)), new Object[0]);
            TextComponentTranslation message = new TextComponentTranslation(Objects.requireNonNull(Server.readString(buffer)), new Object[0]);
            mc.func_193033_an().func_192988_a((IToast)new GuiAchievement((ITextComponent)title, (ITextComponent)message, buffer.readInt() % 3));
        } else if (type == EnumPacketClient.UPDATE_ITEM) {
            int id = buffer.readInt();
            NBTTagCompound compound = Server.readNBT(buffer);
            ItemStack stack = player.field_71071_by.func_70301_a(id);
            if (!stack.func_190926_b()) {
                ((ItemStackWrapper)Objects.requireNonNull(NpcAPI.Instance()).getIItemStack(stack)).setMCNbt(compound);
            }
        } else if (type == EnumPacketClient.VISIBLE_FALSE) {
            void var9_141;
            WorldClient w = (WorldClient)player.field_70170_p;
            UUID uuid = Server.readUUID(buffer);
            int id = buffer.readInt();
            List list = w.func_175644_a(EntityNPCInterface.class, entity -> entity.func_110124_au().equals(uuid));
            if (list.isEmpty()) {
                List list2 = w.func_175644_a(EntityNPCInterface.class, entity -> entity.func_145782_y() == id);
            }
            for (EntityNPCInterface npc : var9_141) {
                if (npc == null) continue;
                w.func_72900_e((Entity)npc);
            }
            if (!ClientProxy.notVisibleNPC.containsKey(player.field_70170_p.field_73011_w.getDimension())) {
                ClientProxy.notVisibleNPC.put(player.field_70170_p.field_73011_w.getDimension(), new ArrayList());
            }
            ClientProxy.notVisibleNPC.get(player.field_70170_p.field_73011_w.getDimension()).add(uuid);
        } else if (type == EnumPacketClient.VISIBLE_TRUE) {
            void var9_144;
            WorldClient w = (WorldClient)player.field_70170_p;
            UUID uuid = Server.readUUID(buffer);
            int id = buffer.readInt();
            List list = w.func_175644_a(EntityNPCInterface.class, entity -> entity.func_110124_au().equals(uuid));
            if (list.isEmpty()) {
                List list3 = w.func_175644_a(EntityNPCInterface.class, entity -> entity.func_145782_y() == id);
            }
            if (var9_144.isEmpty()) {
                LogWriter.debug("Tries to visible summon an entity into the client world.");
                EntitySpawnMessageHelper.spawn(buffer);
            }
            if (!var9_144.isEmpty()) {
                for (EntityNPCInterface npc : var9_144) {
                    if (npc != null) continue;
                    LogWriter.debug("Tries to visible summon an NPC into the client world.");
                    EntitySpawnMessageHelper.spawn(buffer);
                }
            }
            if (!ClientProxy.notVisibleNPC.containsKey(player.field_70170_p.field_73011_w.getDimension())) {
                ClientProxy.notVisibleNPC.put(player.field_70170_p.field_73011_w.getDimension(), new ArrayList());
            }
            for (UUID uID : ClientProxy.notVisibleNPC.get(player.field_70170_p.field_73011_w.getDimension())) {
                if (!uuid.equals(uID)) continue;
                ClientProxy.notVisibleNPC.get(player.field_70170_p.field_73011_w.getDimension()).remove(uID);
                return;
            }
        } else if (type == EnumPacketClient.SYNC_ADD || type == EnumPacketClient.SYNC_END) {
            EnumSync synctype = EnumSync.values()[buffer.readInt()];
            LogWriter.debug(type.toString().replace("SYNC_", "") + " data type: " + (Object)((Object)synctype));
            NBTTagCompound compound = Server.readNBT(buffer);
            SyncController.add(synctype, compound, type == EnumPacketClient.SYNC_END, player);
            if (synctype == EnumSync.QuestCategoriesData) {
                if (mc.field_71462_r instanceof GuiNPCManageQuest) {
                    mc.field_71462_r.func_73866_w_();
                }
            } else if (synctype == EnumSync.DialogCategoriesData) {
                if (mc.field_71462_r instanceof GuiNPCManageDialogs) {
                    mc.field_71462_r.func_73866_w_();
                }
            } else if (synctype == EnumSync.PlayerData) {
                data.setNBT(compound);
            } else if (synctype == EnumSync.ItemScriptedModels) {
                if (player.func_184102_h() == null) {
                    ItemScripted.Resources = NBTTags.getIntegerStringMap(compound.func_150295_c("List", 10));
                }
                CustomNpcs.proxy.reloadItemTextures();
            } else if (synctype == EnumSync.PlayerQuestData) {
                data.setNBT(compound);
            }
        } else if (type == EnumPacketClient.SYNC_UPDATE) {
            EnumSync synctype = EnumSync.values()[buffer.readInt()];
            SyncController.update(synctype, Server.readNBT(buffer), buffer, player);
            if (synctype == EnumSync.MailData) {
                GuiScreen screen = mc.field_71462_r;
                if (screen instanceof GuiMailbox) {
                    screen.func_73866_w_();
                } else if (screen instanceof GuiMailmanWrite) {
                    if (GuiMailmanWrite.mail != null) {
                        PlayerMail mail = data.mailData.get(GuiMailmanWrite.mail);
                        if (GuiMailmanWrite.mail.money > 0 && mail.money <= 0 || GuiMailmanWrite.mail.ransom > 0 && mail.ransom <= 0) {
                            MusicController.Instance.forcePlaySound(SoundCategory.PLAYERS, "customnpcs:mail.money", (float)player.field_70165_t, (float)player.field_70163_u, (float)player.field_70161_v, 1.0f, 0.9f + 0.2f * (float)Math.random());
                        }
                        if (mail != null) {
                            GuiMailmanWrite.mail = mail;
                        }
                    }
                    screen.func_73866_w_();
                }
            }
        } else if (type == EnumPacketClient.CHEST_NAME) {
            GuiScreen screen = mc.field_71462_r;
            if (screen instanceof GuiCustomChest) {
                ((GuiCustomChest)screen).title = new TextComponentTranslation(Objects.requireNonNull(Server.readString(buffer)), new Object[0]).func_150254_d();
            }
        } else if (type == EnumPacketClient.SYNC_REMOVE) {
            EnumSync synctype = EnumSync.values()[buffer.readInt()];
            LogWriter.debug("Remove data type: " + (Object)((Object)synctype));
            SyncController.remove(synctype, buffer.readInt(), buffer);
        } else if (type == EnumPacketClient.MARK_DATA) {
            Entity entity4 = mc.field_71441_e.func_73045_a(buffer.readInt());
            if (!(entity4 instanceof EntityLivingBase)) {
                return;
            }
            MarkData mark = MarkData.get((EntityLivingBase)entity4);
            mark.setNBT(Server.readNBT(buffer));
            MarkRenderer.needReload = true;
        } else if (type == EnumPacketClient.DIALOG) {
            Entity entity5 = mc.field_71441_e.func_73045_a(buffer.readInt());
            if (!(entity5 instanceof EntityNPCInterface)) {
                return;
            }
            Dialog dialog = DialogController.instance.dialogs.get(buffer.readInt());
            NoppesUtil.openDialog(dialog, (EntityNPCInterface)entity5, player);
        } else if (type == EnumPacketClient.DIALOG_DUMMY) {
            EntityDialogNpc npc = new EntityDialogNpc(player.field_70170_p);
            npc.display.setName(Server.readString(buffer));
            EntityUtil.Copy((EntityLivingBase)player, (EntityLivingBase)npc);
            Dialog dialog = new Dialog(null);
            dialog.load(Server.readNBT(buffer));
            NoppesUtil.openDialog(dialog, npc, player);
        } else if (type == EnumPacketClient.QUEST_COMPLETION) {
            int id = buffer.readInt();
            Quest quest = (Quest)QuestController.instance.get(id);
            if (!quest.completeText.isEmpty()) {
                NoppesUtil.openGUI(player, new GuiQuestCompletion(quest));
            } else if (quest.rewardType == EnumRewardType.ONE_SELECT && !quest.rewardItems.func_191420_l()) {
                NoppesUtilPlayer.sendData(EnumPlayerPacket.QuestChooseReward, quest.id);
            } else {
                NoppesUtilPlayer.sendData(EnumPlayerPacket.QuestCompletion, id);
            }
        } else if (type == EnumPacketClient.EDIT_NPC) {
            int entityID = buffer.readInt();
            Entity entity6 = mc.field_71441_e.func_73045_a(entityID);
            if (entityID == -1 || !(entity6 instanceof EntityNPCInterface)) {
                NoppesUtil.setLastNpc(null);
            } else {
                NoppesUtil.setLastNpc((EntityNPCInterface)entity6);
            }
        } else if (type == EnumPacketClient.STOP_SOUND) {
            String soundRes = Server.readString(buffer);
            int categoryType = buffer.readInt();
            if (categoryType >= 0 && categoryType < SoundCategory.values().length) {
                MusicController.Instance.stopSound(soundRes, SoundCategory.values()[categoryType]);
            } else {
                MusicController.Instance.stopSounds();
            }
        } else if (type == EnumPacketClient.PLAY_SOUND) {
            MusicController.Instance.playSound(SoundCategory.PLAYERS, Server.readString(buffer), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readFloat(), buffer.readFloat());
        } else if (type == EnumPacketClient.FORCE_PLAY_SOUND) {
            int categoryType = buffer.readInt();
            SoundCategory cat = SoundCategory.PLAYERS;
            if (categoryType >= 0 && categoryType < SoundCategory.values().length) {
                cat = SoundCategory.values()[categoryType];
            }
            MusicController.Instance.forcePlaySound(cat, Server.readString(buffer), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
        } else if (type == EnumPacketClient.UPDATE_NPC) {
            NBTTagCompound compound = Server.readNBT(buffer);
            Entity entity7 = mc.field_71441_e.func_73045_a(compound.func_74762_e("EntityId"));
            if (entity7 instanceof EntityNPCInterface) {
                ((EntityNPCInterface)entity7).readSpawnData(compound);
            }
        } else if (type == EnumPacketClient.ROLE) {
            NBTTagCompound compound = Server.readNBT(buffer);
            Entity entity8 = mc.field_71441_e.func_73045_a(compound.func_74762_e("EntityId"));
            if (!(entity8 instanceof EntityNPCInterface)) {
                return;
            }
            ((EntityNPCInterface)entity8).advanced.setRole(compound.func_74762_e("Type"));
            ((EntityNPCInterface)entity8).advanced.roleInterface.load(compound);
            NoppesUtil.setLastNpc((EntityNPCInterface)entity8);
        } else if (type == EnumPacketClient.GUI) {
            EnumGuiType gui = EnumGuiType.values()[buffer.readInt()];
            CustomNpcs.proxy.openGui(NoppesUtil.getLastNpc(), gui, buffer.readInt(), buffer.readInt(), buffer.readInt());
        } else if (type == EnumPacketClient.PARTICLE) {
            NoppesUtil.spawnParticle(buffer);
        } else if (type == EnumPacketClient.DELETE_ENTITY) {
            Entity entity9 = mc.field_71441_e.func_73045_a(buffer.readInt());
            if (!(entity9 instanceof EntityLivingBase)) {
                return;
            }
            if (entity9 instanceof EntityNPCInterface) {
                ((EntityNPCInterface)entity9).delete();
            } else {
                entity9.func_70106_y();
            }
        } else if (type == EnumPacketClient.SCROLL_LIST) {
            NoppesUtil.setScrollList(buffer);
        } else if (type == EnumPacketClient.SCROLL_DATA) {
            NoppesUtil.setScrollData(buffer);
        } else if (type == EnumPacketClient.SCROLL_DATA_PART) {
            NoppesUtil.addScrollData(buffer);
        } else if (type == EnumPacketClient.SCROLL_SELECTED) {
            GuiScreen gui = mc.field_71462_r;
            String selected = Server.readString(buffer);
            assert (selected != null);
            if (selected.equals("Unfreeze Npcs") || selected.equals("Freeze Npcs")) {
                if (CustomNpcs.Server != null && CustomNpcs.Server.func_71262_S()) {
                    CustomNpcs.FreezeNPCs = selected.equals("Freeze Npcs");
                }
                if (gui instanceof GuiNpcRemoteEditor) {
                    gui.func_73866_w_();
                }
            }
            if (!(gui instanceof IScrollData)) {
                return;
            }
            ((IScrollData)gui).setSelected(selected);
        } else if (type == EnumPacketClient.CLONE) {
            NBTTagCompound compound = Server.readNBT(buffer);
            NoppesUtil.openGUI(player, new GuiNpcMobSpawnerAdd(compound));
        } else if (type == EnumPacketClient.GUI_DATA) {
            GuiScreen gui = mc.field_71462_r;
            if (gui == null) {
                return;
            }
            if (gui instanceof GuiNPCInterface && ((GuiNPCInterface)gui).hasSubGui()) {
                gui = ((GuiNPCInterface)gui).getSubGui();
            } else if (gui instanceof GuiContainerNPCInterface && ((GuiContainerNPCInterface)gui).hasSubGui()) {
                gui = ((GuiContainerNPCInterface)gui).getSubGui();
            }
            if (gui instanceof IGuiData) {
                NBTTagCompound compound = Server.readNBT(buffer);
                ((IGuiData)gui).setGuiData(compound);
            }
        } else if (type == EnumPacketClient.GUI_UPDATE) {
            GuiScreen gui = mc.field_71462_r;
            if (gui == null) {
                return;
            }
            gui.func_73866_w_();
        } else if (type == EnumPacketClient.GUI_ERROR) {
            GuiScreen gui = mc.field_71462_r;
            if (!(gui instanceof IGuiError)) {
                return;
            }
            int i = buffer.readInt();
            NBTTagCompound compound = Server.readNBT(buffer);
            ((IGuiError)gui).setError(i, compound);
        } else if (type == EnumPacketClient.GUI_CLOSE) {
            GuiScreen gui = mc.field_71462_r;
            if (gui == null) {
                return;
            }
            if (gui instanceof IGuiClose) {
                buffer.readInt();
                ((IGuiClose)gui).setClose(Server.readNBT(buffer));
                if (gui instanceof GuiMailmanWrite) {
                    return;
                }
            }
            mc.func_147108_a(null);
            mc.func_71381_h();
        } else if (type == EnumPacketClient.VILLAGER_LIST) {
            MerchantRecipeList merchantrecipelist = MerchantRecipeList.func_151390_b((PacketBuffer)new PacketBuffer(buffer));
            ServerEventsHandler.Merchant.func_70930_a(merchantrecipelist);
        } else if (type == EnumPacketClient.CONFIG_FONT) {
            int config = buffer.readInt();
            if (config == 0) {
                String font = Server.readString(buffer);
                int size = buffer.readInt();
                Runnable runnable = () -> {
                    assert (font != null);
                    if (!font.isEmpty()) {
                        CustomNpcs.FontType = font;
                        CustomNpcs.FontSize = size;
                        ClientProxy.Font.clear();
                        ClientProxy.Font = new ClientProxy.FontContainer(CustomNpcs.FontType, CustomNpcs.FontSize);
                        CustomNpcs.Config.resetConfig();
                        player.func_145747_a((ITextComponent)new TextComponentTranslation("Font set to %s", new Object[]{ClientProxy.Font.getName()}));
                    } else {
                        player.func_145747_a((ITextComponent)new TextComponentTranslation("Current font is %s", new Object[]{ClientProxy.Font.getName()}));
                    }
                };
                mc.func_152344_a(runnable);
            }
        } else if (type == EnumPacketClient.MESSAGE_DATA) {
            boolean bl;
            void var9_151;
            NBTTagCompound compound = Server.readNBT(buffer);
            Object[] titleObjs = new Object[]{};
            if (compound.func_150297_b("TitleObjects", 9) && ((NBTTagList)compound.func_74781_a("TitleObjects")).func_150303_d() == 8) {
                void var9_147;
                NBTTagList list = compound.func_150295_c("TitleObjects", 8);
                titleObjs = new Object[list.func_74745_c()];
                boolean bl2 = false;
                while (var9_147 < list.func_74745_c()) {
                    titleObjs[var9_147] = list.func_150307_f((int)var9_147);
                    ++var9_147;
                }
            }
            Object[] mesObjs = new Object[]{};
            if (compound.func_150297_b("MessageObjects", 9) && ((NBTTagList)compound.func_74781_a("MessageObjects")).func_150303_d() == 8) {
                NBTTagList nBTTagList = compound.func_150295_c("MessageObjects", 8);
                mesObjs = new Object[nBTTagList.func_74745_c()];
                for (int i = 0; i < nBTTagList.func_74745_c(); ++i) {
                    mesObjs[i] = nBTTagList.func_150307_f(i);
                }
            }
            TextComponentTranslation textComponentTranslation = new TextComponentTranslation(compound.func_74779_i("Title"), titleObjs);
            TextComponentTranslation message = new TextComponentTranslation(compound.func_74779_i("Message"), mesObjs);
            if (compound.func_150297_b("QuestID", 3)) {
                IQuest quest = QuestController.instance.get(compound.func_74762_e("QuestID"));
                if (quest == null) {
                    return;
                }
                TextComponentTranslation textComponentTranslation2 = new TextComponentTranslation("quest.name", new Object[0]);
                textComponentTranslation2.func_150257_a((ITextComponent)new TextComponentString(": "));
                textComponentTranslation2.func_150257_a((ITextComponent)new TextComponentString(quest.getTitle()));
                int[] nArray = compound.func_74759_k("Progress");
                if (compound.func_74779_i("Type").equalsIgnoreCase("craft")) {
                    ItemStack item = new ItemStack(compound.func_74775_l("Item"));
                    message = new TextComponentTranslation(item.func_82833_r(), new Object[0]);
                } else {
                    message = new TextComponentTranslation(compound.func_74779_i("TargetName"), new Object[0]);
                }
                if (nArray[0] >= nArray[1]) {
                    message.func_150257_a((ITextComponent)new TextComponentString(" -"));
                    message.func_150257_a((ITextComponent)new TextComponentTranslation("quest.task." + compound.func_74779_i("Type") + ".0", new Object[0]));
                } else {
                    message.func_150257_a((ITextComponent)new TextComponentString(" = " + nArray[0] + "/" + nArray[1]));
                }
            }
            Object[] visible = null;
            for (Field f : GuiToast.class.getDeclaredFields()) {
                if (!f.getType().getName().contains("ToastInstance")) continue;
                try {
                    f.setAccessible(true);
                    visible = (Object[])f.get(mc.func_193033_an());
                }
                catch (Exception exception) {
                    LogWriter.debug(exception.toString());
                }
            }
            if (visible == null) {
                return;
            }
            boolean bl3 = false;
            for (void var16_221 : visible) {
                if (var16_221 == null) continue;
                Field toast = var16_221.getClass().getDeclaredFields()[0];
                toast.setAccessible(true);
                if (!(toast.get(var16_221) instanceof GuiAchievement)) continue;
                GuiAchievement achn = (GuiAchievement)toast.get(var16_221);
                Field titleF = GuiAchievement.class.getDeclaredFields()[3];
                Field typeF = GuiAchievement.class.getDeclaredFields()[4];
                titleF.setAccessible(true);
                typeF.setAccessible(true);
                String titleD = Util.instance.deleteColor((String)titleF.get(achn));
                int typeD = (Integer)typeF.get(achn);
                if (!titleD.equals(Util.instance.deleteColor(var9_151.func_150254_d())) || compound.func_74762_e("MessageType") != typeD) continue;
                achn.setDisplayedText((ITextComponent)var9_151, (ITextComponent)message);
                bl = true;
            }
            if (!bl) {
                mc.func_193033_an().func_192988_a((IToast)new GuiAchievement((ITextComponent)var9_151, (ITextComponent)message, compound.func_74762_e("MessageType")));
            }
        } else if (type == EnumPacketClient.NPC_VISUAL_DATA) {
            Entity entity10 = player.field_70170_p.func_73045_a(buffer.readInt());
            if (entity10 instanceof EntityNPCInterface) {
                NBTTagCompound compound = Server.readNBT(buffer);
                EntityNPCInterface npcData = (EntityNPCInterface)entity10;
                npcData.stats.setLevel(compound.func_74762_e("NPCLevel"));
                npcData.stats.setRarity(compound.func_74762_e("NPCRarity"));
                npcData.stats.setRarityTitle(compound.func_74779_i("RarityTitle"));
            }
        } else if (type == EnumPacketClient.MARCET_CLOSE) {
            GuiScreen gui;
            Marcet m = (Marcet)MarcetController.getInstance().getMarcet(buffer.readInt());
            if (m != null) {
                m.removeListener(player, false);
            }
            if ((gui = mc.field_71462_r) instanceof GuiNPCTrader) {
                gui.func_146281_b();
            }
        } else if (type == EnumPacketClient.MARCET_DATA) {
            boolean updateGui = false;
            int t = buffer.readInt();
            switch (t) {
                case 0: {
                    MarcetController.getInstance().markets.clear();
                    MarcetController.getInstance().deals.clear();
                    break;
                }
                case 1: {
                    MarcetController.getInstance().loadMarcet(Server.readNBT(buffer));
                    break;
                }
                case 2: {
                    updateGui = true;
                    break;
                }
                case 3: {
                    MarcetController.getInstance().loadDeal(Server.readNBT(buffer));
                    break;
                }
                case 4: {
                    MarcetController.getInstance().removeMarcet(buffer.readInt());
                    updateGui = true;
                }
            }
            if (!updateGui) {
                return;
            }
            GuiScreen gui = mc.field_71462_r;
            if (gui == null) {
                return;
            }
            if (gui instanceof GuiNPCTrader) {
                ((GuiNPCTrader)gui).setGuiData(new NBTTagCompound());
            } else if (gui instanceof GuiNPCManageMarkets) {
                ((GuiNPCManageMarkets)gui).setGuiData(new NBTTagCompound());
            }
        } else if (type == EnumPacketClient.DETECT_HELD_ITEM) {
            try {
                player.field_71071_by.func_70299_a(buffer.readInt(), new ItemStack(Server.readNBT(buffer)));
                return;
            }
            catch (Exception e) {
                LogWriter.error(e);
                ItemStack held = new ItemStack(Server.readNBT(buffer));
                player.field_71071_by.func_70437_b(held);
            }
        } else if (type == EnumPacketClient.BORDER_DATA) {
            int id = buffer.readInt();
            if (id == -1) {
                BorderController.getInstance().regions.clear();
                return;
            }
            if (id == -2) {
                GuiScreen gui = mc.field_71462_r;
                if (gui instanceof GuiNPCInterface) {
                    gui.func_73866_w_();
                }
                return;
            }
            BorderController.getInstance().loadRegion(Server.readNBT(buffer));
        } else if (type == EnumPacketClient.SAVE_SCHEMATIC) {
            NBTTagCompound compound = Server.readNBT(buffer);
            String name = compound.func_74779_i("Name") + ".schematic";
            Schematic schema = new Schematic(name);
            schema.load(compound);
            schema.save(player);
            SchematicController.Instance.map.put(name.toLowerCase(), new SchematicWrapper(schema));
        } else if (type == EnumPacketClient.GET_SCHEMATIC) {
            if (ClientEventHandler.schemaPos == null || ClientEventHandler.schema == null) {
                return;
            }
            int x = ClientEventHandler.schemaPos.func_177958_n();
            int y = ClientEventHandler.schemaPos.func_177956_o();
            int z = ClientEventHandler.schemaPos.func_177952_p();
            Client.sendData(EnumPacketServer.SchematicsBuild, x, y, z, ClientEventHandler.rotation, ClientEventHandler.schema.getNBT());
        } else if (type == EnumPacketClient.UPDATE_HUD) {
            NBTTagCompound compound = Server.readNBT(buffer);
            data.hud.loadNBTData(compound);
        } else if (type == EnumPacketClient.DIMENSION_IDS) {
            ClientHandler.getInstance().sync(Server.readIntArray(buffer));
        } else if (type == EnumPacketClient.DROP_GROUP_DATA) {
            NBTTagCompound nbtTemplate = Server.readNBT(buffer);
            if (nbtTemplate.func_150296_c().isEmpty()) {
                DropController.getInstance().templates.clear();
                return;
            }
            if (!nbtTemplate.func_150297_b("Name", 8)) {
                return;
            }
            DropsTemplate template = new DropsTemplate(nbtTemplate.func_74775_l("Groups"));
            DropController.getInstance().templates.put(nbtTemplate.func_74779_i("Name"), template);
        } else if (type == EnumPacketClient.SET_TILE_DATA) {
            NBTTagCompound compound = Server.readNBT(buffer);
            TileEntity tile = player.field_70170_p.func_175625_s(new BlockPos(compound.func_74762_e("x"), compound.func_74762_e("y"), compound.func_74762_e("z")));
            if (tile != null) {
                tile.func_145839_a(compound);
            }
        } else if (type == EnumPacketClient.ANIMATION_DATA_SET) {
            IEntityPlayerMixin pl;
            if (buffer.readBoolean()) {
                if (mc.field_71441_e.field_73011_w.getDimension() == buffer.readInt()) {
                    Entity entity11 = mc.field_71441_e.func_73045_a(buffer.readInt());
                    if (!(entity11 instanceof EntityNPCInterface)) {
                        return;
                    }
                    ((EntityNPCInterface)entity11).animation.load(Server.readNBT(buffer));
                }
            } else if (mc.field_71441_e.field_73011_w.getDimension() == buffer.readInt() && (pl = (IEntityPlayerMixin)mc.field_71441_e.func_152378_a(Server.readUUID(buffer))) != null) {
                pl.npcs$getAnimation().load(Server.readNBT(buffer));
            }
        } else if (type == EnumPacketClient.ANIMATION_DATA_STOP_ANIMATION) {
            IEntityPlayerMixin pl;
            if (buffer.readBoolean()) {
                if (mc.field_71441_e.field_73011_w.getDimension() == buffer.readInt()) {
                    Entity entity12 = mc.field_71441_e.func_73045_a(buffer.readInt());
                    if (!(entity12 instanceof EntityNPCInterface)) {
                        return;
                    }
                    ((EntityNPCInterface)entity12).animation.stopAnimation();
                }
            } else if (mc.field_71441_e.field_73011_w.getDimension() == buffer.readInt() && (pl = (IEntityPlayerMixin)mc.field_71441_e.func_152378_a(Server.readUUID(buffer))) != null) {
                pl.npcs$getAnimation().stopAnimation();
            }
        } else if (type == EnumPacketClient.ANIMATION_DATA_STOP_EMOTION) {
            IEntityPlayerMixin pl;
            if (buffer.readBoolean()) {
                if (mc.field_71441_e.field_73011_w.getDimension() == buffer.readInt()) {
                    Entity entity13 = mc.field_71441_e.func_73045_a(buffer.readInt());
                    if (!(entity13 instanceof EntityNPCInterface)) {
                        return;
                    }
                    ((EntityNPCInterface)entity13).animation.stopEmotion();
                }
            } else if (mc.field_71441_e.field_73011_w.getDimension() == buffer.readInt() && (pl = (IEntityPlayerMixin)mc.field_71441_e.func_152378_a(Server.readUUID(buffer))) != null) {
                pl.npcs$getAnimation().stopEmotion();
            }
        } else if (type == EnumPacketClient.ANIMATION_DATA_RUN_ANIMATION) {
            AnimationConfig ac;
            IEntityPlayerMixin pl;
            DataAnimation animation = null;
            if (buffer.readBoolean()) {
                if (mc.field_71441_e.field_73011_w.getDimension() == buffer.readInt()) {
                    Entity entity14 = mc.field_71441_e.func_73045_a(buffer.readInt());
                    if (!(entity14 instanceof EntityNPCInterface)) {
                        return;
                    }
                    animation = ((EntityNPCInterface)entity14).animation;
                }
            } else if (mc.field_71441_e.field_73011_w.getDimension() == buffer.readInt() && (pl = (IEntityPlayerMixin)mc.field_71441_e.func_152378_a(Server.readUUID(buffer))) != null) {
                animation = pl.npcs$getAnimation();
            }
            if (animation != null && (ac = AnimationController.getInstance().animations.get(buffer.readInt())) != null) {
                animation.tryRunAnimation(ac, AnimationKind.get(buffer.readInt()));
            }
        } else if (type == EnumPacketClient.ANIMATION_DATA_BASE_ANIMATIONS) {
            IEntityPlayerMixin pl;
            if (buffer.readBoolean()) {
                if (mc.field_71441_e.field_73011_w.getDimension() == buffer.readInt()) {
                    Entity entity15 = mc.field_71441_e.func_73045_a(buffer.readInt());
                    if (!(entity15 instanceof EntityNPCInterface)) {
                        return;
                    }
                    Map<Object, Object> map = Server.readMap(buffer);
                    ((EntityNPCInterface)entity15).animation.loadBaseAnimations(map);
                }
            } else if (mc.field_71441_e.field_73011_w.getDimension() == buffer.readInt() && (pl = (IEntityPlayerMixin)mc.field_71441_e.func_152378_a(Server.readUUID(buffer))) != null) {
                pl.npcs$getAnimation().loadBaseAnimations(Server.readMap(buffer));
            }
        } else if (type == EnumPacketClient.EMOTION_DATA_STOP_ANIMATION) {
            IEntityPlayerMixin pl;
            if (buffer.readBoolean()) {
                if (mc.field_71441_e.field_73011_w.getDimension() == buffer.readInt()) {
                    Entity entity16 = mc.field_71441_e.func_73045_a(buffer.readInt());
                    if (!(entity16 instanceof EntityNPCInterface)) {
                        return;
                    }
                    ((EntityNPCInterface)entity16).animation.stopEmotion();
                }
            } else if (mc.field_71441_e.field_73011_w.getDimension() == buffer.readInt() && (pl = (IEntityPlayerMixin)mc.field_71441_e.func_152378_a(Server.readUUID(buffer))) != null) {
                pl.npcs$getAnimation().stopEmotion();
            }
        } else if (type == EnumPacketClient.EMOTION_DATA_RUN_ANIMATION) {
            EmotionConfig ec;
            IEntityPlayerMixin pl;
            DataAnimation animation = null;
            if (buffer.readBoolean()) {
                if (mc.field_71441_e.field_73011_w.getDimension() == buffer.readInt()) {
                    Entity entity17 = mc.field_71441_e.func_73045_a(buffer.readInt());
                    if (!(entity17 instanceof EntityNPCInterface)) {
                        return;
                    }
                    animation = ((EntityNPCInterface)entity17).animation;
                }
            } else if (mc.field_71441_e.field_73011_w.getDimension() == buffer.readInt() && (pl = (IEntityPlayerMixin)mc.field_71441_e.func_152378_a(Server.readUUID(buffer))) != null) {
                animation = pl.npcs$getAnimation();
            }
            if (animation != null && (ec = AnimationController.getInstance().emotions.get(buffer.readInt())) != null) {
                animation.tryRunEmotion(ec);
            }
        } else if (type == EnumPacketClient.UPDATE_NPC_ANIMATION) {
            if (mc.field_71441_e.field_73011_w.getDimension() != buffer.readInt()) {
                return;
            }
            Entity entity18 = mc.field_71441_e.func_73045_a(buffer.readInt());
            if (!(entity18 instanceof EntityNPCInterface)) {
                return;
            }
            ((EntityNPCInterface)entity18).currentAnimation = buffer.readInt();
            ((EntityNPCInterface)entity18).updateHitbox();
        } else if (type == EnumPacketClient.UPDATE_NPC_NAVIGATION) {
            NBTTagCompound compound = Server.readNBT(buffer);
            Entity entity19 = mc.field_71441_e.func_73045_a(compound.func_74762_e("EntityId"));
            if (entity19 instanceof EntityNPCInterface) {
                EntityNPCInterface npc = (EntityNPCInterface)entity19;
                if (compound.func_150297_b("Navigating", 10)) {
                    Path path;
                    npc.navigating = path = Server.readPathToNBT(compound.func_74775_l("Navigating"));
                    npc.func_70661_as().func_75484_a(path, 1.0);
                } else {
                    npc.navigating = null;
                    npc.func_70661_as().func_75484_a(null, 1.0);
                }
            }
        } else if (type == EnumPacketClient.UPDATE_NPC_AI_TARGET) {
            NBTTagCompound compound = Server.readNBT(buffer);
            Entity entity20 = mc.field_71441_e.func_73045_a(compound.func_74762_e("EntityId"));
            if (!(entity20 instanceof EntityNPCInterface)) {
                return;
            }
            EntityNPCInterface npc = (EntityNPCInterface)entity20;
            if (compound.func_150297_b("aiIsSneak", 1)) {
                npc.aiIsSneak = compound.func_74767_n("aiIsSneak");
                npc.func_70095_a(npc.aiIsSneak);
            }
        } else if (type == EnumPacketClient.UPDATE_NPC_TARGET) {
            int entityId = buffer.readInt();
            Entity entity21 = mc.field_71441_e.func_73045_a(entityId);
            if (!(entity21 instanceof EntityNPCInterface)) {
                return;
            }
            EntityNPCInterface npc = (EntityNPCInterface)entity21;
            int n = buffer.readInt();
            if (n > -1) {
                Entity target = npc.field_70170_p.func_73045_a(n);
                if (target instanceof EntityLivingBase) {
                    npc.func_70624_b((EntityLivingBase)target);
                } else {
                    npc.func_70624_b(null);
                }
            } else {
                npc.func_70624_b(null);
            }
        } else if (type == EnumPacketClient.SCRIPT_PACKAGE) {
            EventHooks.onScriptPackage(player, Server.readNBT(buffer));
        } else if (type == EnumPacketClient.SCRIPT_CLIENT) {
            ScriptController.HasStart = true;
            NBTTagCompound compound = Server.readNBT(buffer);
            ScriptController.Instance.setClientScripts(compound);
        } else if (type == EnumPacketClient.SEND_FILE_LIST) {
            NBTTagCompound compound = Server.readNBT(buffer);
            for (int i = 0; i < compound.func_150295_c("FileList", 10).func_74745_c(); ++i) {
                NBTTagCompound tempFile = compound.func_150295_c("FileList", 10).func_150305_b(i);
                String string = tempFile.func_74779_i("name");
                if (!ClientProxy.loadFiles.containsKey(string)) {
                    ClientProxy.loadFiles.put(string, new TempFile());
                }
                TempFile file = ClientProxy.loadFiles.get(string);
                file.setTitle(tempFile);
            }
            ClientTickHandler.loadFiles();
        } else if (type == EnumPacketClient.NPC_MOVING_PATH) {
            Entity entity22 = player.field_70170_p.func_73045_a(buffer.readInt());
            if (entity22 instanceof EntityCustomNpc) {
                ((EntityCustomNpc)entity22).ais.readToNBT(Server.readNBT(buffer));
            }
        } else if (type == EnumPacketClient.SEND_FILE_PART) {
            if (buffer.readBoolean()) {
                ClientProxy.loadFiles.remove(Server.readString(buffer));
                return;
            }
            int part = buffer.readInt();
            String name = Server.readString(buffer);
            if (!ClientProxy.loadFiles.containsKey(name)) {
                return;
            }
            TempFile file = ClientProxy.loadFiles.get(name);
            file.data.put(part, Server.readString(buffer));
            file.lastLoad = System.currentTimeMillis() - 15000L;
            file.tryLoads = 0;
            if (file.isLoad()) {
                if (file.saveType == 1) {
                    LogWriter.info("Script Client file was received from the Server: \"" + name + "\"");
                    if (player.field_71075_bZ.field_75098_d || data.game.op) {
                        char c = '\u00a7';
                        String s = "" + file.size;
                        if (file.size > 999L) {
                            s = Util.instance.getTextReducedNumber(file.size, false, false, false);
                        }
                        TextComponentString message = new TextComponentString(c + "7[" + c + "2CustomNpcs" + c + "7]: Received client script: \"" + c + "f" + name + c + "7\" (" + s + c + "7b)");
                        player.func_145747_a((ITextComponent)message);
                    }
                    ScriptController.Instance.clients.put(name, file.getDataText());
                    ScriptController.Instance.clientSizes.put(name, file.size);
                } else {
                    file.save();
                }
                ClientProxy.loadFiles.remove(name);
            }
            ClientTickHandler.loadFiles();
        } else if (type == EnumPacketClient.PLAY_CAMERA_SHAKING) {
            ClientGuiEventHandler.crashes.set(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readBoolean());
        } else if (type == EnumPacketClient.STOP_CAMERA_SHAKING) {
            ClientGuiEventHandler.crashes.isActive = false;
        } else if (type == EnumPacketClient.SHOW_BANK_PLAYER) {
            ContainerNPCBank.editPlayerBankData = Server.readString(buffer);
            if (ContainerNPCBank.editPlayerBankData != null && ContainerNPCBank.editPlayerBankData.isEmpty()) {
                ContainerNPCBank.editPlayerBankData = null;
            }
        } else if (type == EnumPacketClient.BANK_CEIL_OPEN) {
            if (!(player.field_71070_bA instanceof ContainerNPCBank)) {
                return;
            }
            ((ContainerNPCBank)player.field_71070_bA).dataCeil = buffer.readInt();
        } else if (type == EnumPacketClient.NPC_DATA) {
            NBTTagCompound compound = Server.readNBT(buffer);
            Entity e = player.field_70170_p.func_73045_a(compound.func_74762_e("EntityID"));
            if (e instanceof EntityNPCInterface) {
                e.func_70020_e(compound);
            }
        } else if (type == EnumPacketClient.PLAYER_SKIN_ADD) {
            NBTTagCompound compound = Server.readNBT(buffer);
            UUID uuid = PlayerSkinController.getInstance().loadPlayerSkin(compound);
            ClientProxy.resetSkin(uuid);
        } else if (type == EnumPacketClient.PLAYER_SKIN_GET) {
            ClientProxy.sendSkin(player.func_110124_au());
        } else if (type == EnumPacketClient.MINIMAP_DATA) {
            PlayerMiniMapData mm = data.minimap;
            String modName = mm.modName;
            mm.loadNBTData(Server.readNBT(buffer));
            int isChanged = 0;
            if (modName.endsWith("journeymap")) {
                try {
                    Class<?> clazz = Class.forName("journeymap.client.waypoint.WaypointStore");
                    Class<?> wp = Class.forName("journeymap.client.model.Waypoint");
                    Constructor<?> wc = null;
                    for (Constructor<?> c : wp.getDeclaredConstructors()) {
                        Parameter[] parameterArray;
                        if (c.getParameterCount() != 12 || (parameterArray = c.getParameters())[0].getType() != String.class || parameterArray[1].getType() != Integer.TYPE || parameterArray[2].getType() != Integer.TYPE || parameterArray[3].getType() != Integer.TYPE || parameterArray[4].getType() != Boolean.TYPE || parameterArray[5].getType() != Integer.TYPE || parameterArray[6].getType() != Integer.TYPE || parameterArray[7].getType() != Integer.TYPE || !parameterArray[8].getType().getSimpleName().equals("Type") || parameterArray[9].getType() != String.class || parameterArray[10].getType() != Integer.class || parameterArray[11].getType() != Collection.class) continue;
                        wc = c;
                        break;
                    }
                    Field field = clazz.getDeclaredField("cache");
                    Field groupCacheField = clazz.getDeclaredField("groupCache");
                    Field dimensionsField = clazz.getDeclaredField("dimensions");
                    Method load = null;
                    Object var16_223 = null;
                    for (Method m : clazz.getDeclaredMethods()) {
                        if (m.getName().equals("load") && m.getParameterCount() == 2 && m.getParameters()[0].getType() == Collection.class && m.getParameters()[1].getType() == Boolean.TYPE) {
                            load = m;
                        }
                        if (!m.getName().equals("remove") || m.getParameterCount() != 1 || !m.getParameters()[0].getType().getSimpleName().equals("Waypoint")) continue;
                        Method method = m;
                    }
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    if (!groupCacheField.isAccessible()) {
                        groupCacheField.setAccessible(true);
                    }
                    if (!dimensionsField.isAccessible()) {
                        dimensionsField.setAccessible(true);
                    }
                    Object waypointStore = clazz.getEnumConstants()[0];
                    Set dimensions = (Set)dimensionsField.get(waypointStore);
                    dimensions.clear();
                    Cache groupCache = (Cache)groupCacheField.get(waypointStore);
                    groupCache.invalidateAll();
                    Cache cache = (Cache)field.get(waypointStore);
                    ConcurrentMap map = cache.asMap();
                    for (Object name : map.keySet()) {
                        void var16_224;
                        assert (var16_224 != null);
                        var16_224.invoke(waypointStore, map.get(name));
                    }
                    cache.invalidateAll();
                    isChanged = 1;
                    ArrayList waypoints = new ArrayList();
                    for (MiniMapData mmd : mm.points) {
                        int dimID = mmd.dimIDs[0];
                        Object t = null;
                        for (Object enumType : wp.getClasses()[0].getEnumConstants()) {
                            if (t == null) {
                                t = enumType;
                            }
                            if (!enumType.toString().equalsIgnoreCase(mmd.type)) continue;
                            t = enumType;
                            break;
                        }
                        if (t == null) continue;
                        int x = (int)mmd.pos.getX();
                        int y = (int)mmd.pos.getY();
                        int z = (int)mmd.pos.getZ();
                        Color color = new Color(mmd.color);
                        ArrayList<Integer> dim = new ArrayList<Integer>();
                        for (int dId : mmd.dimIDs) {
                            dim.add(dId);
                        }
                        assert (wc != null);
                        Object waypoint = wc.newInstance(mmd.name, x, y, z, mmd.isEnable, color.getRed(), color.getGreen(), color.getBlue(), t, "journeymap", dimID, dim);
                        wp.getDeclaredMethod("setIcon", String.class).invoke(waypoint, mmd.icon);
                        waypoints.add(waypoint);
                    }
                    assert (load != null);
                    load.invoke(waypointStore, waypoints, true);
                }
                catch (Exception exception) {
                    isChanged = 2;
                }
            } else if (modName.endsWith("xaerominimap")) {
                try {
                    Class<?> clazz = Class.forName("xaero.common.XaeroMinimapSession");
                    Object minimapSession = clazz.getDeclaredMethod("getCurrentSession", new Class[0]).invoke(clazz, new Object[0]);
                    Object waypointsManager = clazz.getDeclaredMethod("getWaypointsManager", new Class[0]).invoke(minimapSession, new Object[0]);
                    Method method = waypointsManager.getClass().getDeclaredMethod("getWaypointMap", new Class[0]);
                    HashMap waypointMap = (HashMap)method.invoke(waypointsManager, new Object[0]);
                    String mainContainerID = (String)waypointsManager.getClass().getDeclaredMethod("getAutoRootContainerID", new Class[0]).invoke(waypointsManager, new Object[0]);
                    Object wwrc = waypointMap.get(mainContainerID);
                    Field field = wwrc.getClass().getDeclaredField("dimensionTypes");
                    field.setAccessible(true);
                    Int2ObjectMap dimensionTypes = (Int2ObjectMap)field.get(wwrc);
                    boolean saveConfig = false;
                    Integer[] groupCache = DimensionManager.getStaticDimensionIDs();
                    int cache = groupCache.length;
                    for (int map = 0; map < cache; ++map) {
                        int dim = groupCache[map];
                        if (dimensionTypes.containsKey(dim)) continue;
                        WorldServer ret = DimensionManager.getWorld((int)dim, (boolean)true);
                        if (ret == null) {
                            DimensionManager.initDimension((int)dim);
                            ret = DimensionManager.getWorld((int)dim);
                        }
                        dimensionTypes.put(dim, wwrc.getClass().getDeclaredMethod("createDimensionType", World.class).invoke(wwrc, ret));
                        saveConfig = true;
                    }
                    if (saveConfig) {
                        wwrc.getClass().getDeclaredMethod("saveConfig", new Class[0]).invoke(wwrc, new Object[0]);
                    }
                    Class<?> xm = Class.forName("xaero.minimap.XaeroMinimap");
                    Object instance = xm.getField("instance").get(xm);
                    File parentFile = (File)xm.getDeclaredMethod("getWaypointsFolder", new Class[0]).invoke(instance, new Object[0]);
                    String world_name = (String)mm.addData.get("xaero_world_name");
                    if (world_name == null || world_name.isEmpty()) {
                        HashMap dimMap = (HashMap)wwrc.getClass().getField("subContainers").get(wwrc);
                        for (String k : dimMap.keySet()) {
                            world_name = (String)dimMap.get(k).getClass().getDeclaredMethod("getKey", new Class[0]).invoke(dimMap.get(k), new Object[0]);
                        }
                    }
                    assert (world_name != null);
                    File worldDir = new File(parentFile, world_name);
                    Gson gson = new Gson();
                    HashMap<File, TempWaypointText> map = new HashMap<File, TempWaypointText>();
                    for (MiniMapData mmd : mm.points) {
                        if (mmd.gsonData.containsKey("temporary") && ((Boolean)gson.fromJson(mmd.gsonData.get("temporary"), Boolean.TYPE)).booleanValue()) continue;
                        int dimID = mmd.dimIDs[0];
                        File dimDir = new File(worldDir, "dim%" + dimID);
                        if (!dimDir.exists() && !dimDir.mkdirs()) continue;
                        File dimFile = new File(dimDir, "/waypoints.txt");
                        StringBuilder text = new StringBuilder();
                        StringBuilder endText = new StringBuilder();
                        if (map.containsKey(dimFile)) continue;
                        if (!dimFile.exists()) {
                            text.append("#\n");
                            text.append("#waypoint:name:initials:x:y:z:color:disabled:type:set:rotate_on_tp:tp_yaw:visibility_type:destination\n");
                            text.append("#\n");
                        } else {
                            FileInputStream inputStream = new FileInputStream(dimFile);
                            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)inputStream, Charsets.UTF_8));){
                                boolean end = false;
                                String line = br.readLine();
                                while (line != null) {
                                    if (!end && line.indexOf("#") != 0) {
                                        end = true;
                                    } else if (line.indexOf("waypoint:") != 0) {
                                        if (end) {
                                            endText.append(line).append('\n');
                                        } else {
                                            text.append(line).append('\n');
                                        }
                                    }
                                    line = br.readLine();
                                }
                            }
                        }
                        map.put(dimFile, new TempWaypointText(text.toString(), endText.toString()));
                    }
                    for (File dimFile : map.keySet()) {
                        Util.instance.saveFile(dimFile, ((TempWaypointText)map.get(dimFile)).getString());
                    }
                    Object settings = xm.getDeclaredMethod("getSettings", new Class[0]).invoke(instance, new Object[0]);
                    Method loadWaypointsFromAllSources = null;
                    for (Method m : settings.getClass().getDeclaredMethods()) {
                        if (!m.getName().equals("loadWaypointsFromAllSources") || m.getParameterCount() != 1) continue;
                        loadWaypointsFromAllSources = m;
                        break;
                    }
                    assert (loadWaypointsFromAllSources != null);
                    loadWaypointsFromAllSources.invoke(settings, waypointsManager);
                }
                catch (Exception exception) {
                    LogWriter.error(exception);
                    isChanged = 2;
                }
            } else if (modName.endsWith("voxelmap")) {
                try {
                    Class<?> clazz = Class.forName("com.mamiyaotaru.voxelmap.VoxelMap");
                    Object instance = clazz.getMethod("getInstance", new Class[0]).invoke(clazz, new Object[0]);
                    Object waypointManager = clazz.getMethod("getWaypointManager", new Class[0]).invoke(instance, new Object[0]);
                    List list = (List)waypointManager.getClass().getMethod("getWaypoints", new Class[0]).invoke(waypointManager, new Object[0]);
                    list.clear();
                    isChanged = 1;
                    Class<?> wc = Class.forName("com.mamiyaotaru.voxelmap.util.Waypoint");
                    Constructor<?> cw = wc.getConstructor(String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, String.class, String.class, TreeSet.class);
                    for (MiniMapData miniMapData : mm.points) {
                        int dimID = miniMapData.dimIDs[0];
                        int x = (int)miniMapData.pos.getX();
                        int y = (int)miniMapData.pos.getY();
                        int z = (int)miniMapData.pos.getZ();
                        Color color = new Color(miniMapData.color);
                        TreeSet<Integer> dim = new TreeSet<Integer>();
                        for (int dId : miniMapData.dimIDs) {
                            dim.add(dId);
                        }
                        String worldName = miniMapData.gsonData.getOrDefault("voxel_world_name", "");
                        if (worldName.isEmpty()) {
                            WorldServer ret = DimensionManager.getWorld((int)dimID, (boolean)true);
                            if (ret == null) {
                                DimensionManager.initDimension((int)dimID);
                                ret = DimensionManager.getWorld((int)dimID);
                            }
                            worldName = ret.func_72827_u();
                        }
                        Object waypoint = cw.newInstance(miniMapData.name, x, z, y, miniMapData.isEnable(), Float.valueOf((float)color.getRed() / 255.0f), Float.valueOf((float)color.getGreen() / 255.0f), Float.valueOf((float)color.getBlue() / 255.0f), miniMapData.icon, worldName, dim);
                        list.add(waypoint);
                    }
                    waypointManager.getClass().getMethod("saveWaypoints", new Class[0]).invoke(waypointManager, new Object[0]);
                    Method loadWaypoints = waypointManager.getClass().getDeclaredMethod("loadWaypoints", new Class[0]);
                    loadWaypoints.setAccessible(true);
                    loadWaypoints.invoke(waypointManager, new Object[0]);
                    Method method = waypointManager.getClass().getDeclaredMethod("enteredDimension", Integer.TYPE);
                    method.setAccessible(true);
                    method.invoke(waypointManager, player.field_70170_p.field_73011_w.getDimension());
                }
                catch (Exception exception) {
                    LogWriter.error(exception);
                    isChanged = 2;
                }
            }
            if (isChanged != 0) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("minimap.set.points." + isChanged, new Object[]{"\u00a77" + modName}));
            }
        } else if (type == EnumPacketClient.NPC_LOOK_POS) {
            Entity npc;
            if (player.field_70170_p.field_73011_w.getDimension() == buffer.readInt() && (npc = player.field_70170_p.func_73045_a(buffer.readInt())) instanceof EntityNPCInterface) {
                int lookId = buffer.readInt();
                ((EntityNPCInterface)npc).lookAt = lookId < 0 ? null : player.field_70170_p.func_73045_a(lookId);
            }
        } else if (type == EnumPacketClient.EVENT_NAMES) {
            ArrayList<Object> list;
            int t;
            String names = Server.readString(buffer);
            if (names == null) {
                return;
            }
            int n = names.indexOf("\u00a76Client") == 0 ? 0 : (t = names.indexOf("\u00a76Server") == 0 ? 1 : 2);
            if (t == 2) {
                list = new ArrayList();
                for (EnumScriptType enumScriptType : EnumScriptType.values()) {
                    list.add(enumScriptType.function);
                }
            } else {
                list = new ArrayList<String>(t == 0 ? ScriptController.forgeClientEventNames.values() : ScriptController.forgeEventNames.values());
            }
            names = names.substring(names.indexOf("\n") + 2);
            names = names.substring(0, names.indexOf(";"));
            for (String string : names.split(", ")) {
                if (list.contains(string)) continue;
                list.add(string);
            }
            Collections.sort(list);
            String string = "";
            StringBuilder text = new StringBuilder();
            for (String string2 : list) {
                void var9_165;
                if (var9_165.isEmpty()) {
                    String string3 = "" + string2.charAt(0);
                } else if (!var9_165.equals("" + string2.charAt(0))) {
                    text.append(System.lineSeparator());
                    String string4 = "" + string2.charAt(0);
                }
                text.append(string2);
                text.append(System.lineSeparator());
            }
            File file = new File(CustomNpcs.Dir.getParentFile().getParentFile().getParentFile(), "all " + (t == 0 ? "client" : (t == 1 ? "forge" : "api")) + " event names.txt");
            Util.instance.saveFile(file, text.toString());
            player.func_145747_a((ITextComponent)new TextComponentString("\u00a7e[\u00a72CustomNpcs\u00a7e]\u00a7r: \u00a77Save event names to file: \u00a7r" + file));
        } else if (type == EnumPacketClient.SCRIPT_CODE) {
            if (mc.field_71462_r instanceof GuiScriptInterface) {
                ((GuiScriptInterface)mc.field_71462_r).addScript(buffer.readInt(), Server.readString(buffer));
            }
        } else if (type == EnumPacketClient.SCRIPT_CONSOLE) {
            if (mc.field_71462_r instanceof GuiScriptInterface) {
                ((GuiScriptInterface)mc.field_71462_r).addConsole(buffer.readInt(), buffer.readLong(), Server.readString(buffer));
            }
        } else if (type == EnumPacketClient.SCRIPT_ERROR) {
            if (!CustomNpcs.DisplayErrorInChat) {
                return;
            }
            String component = Server.readString(buffer);
            if (component == null || component.isEmpty()) {
                return;
            }
            ITextComponent message = ITextComponent.Serializer.func_150699_a((String)component);
            if (message == null || message.func_150254_d().isEmpty()) {
                return;
            }
            player.func_145747_a(message);
        }
    }

    @SubscribeEvent
    public void onPacketData(FMLNetworkEvent.ClientCustomPacketEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        ByteBuf buffer = event.getPacket().payload();
        Minecraft.func_71410_x().func_152344_a(() -> this.lambda$onPacketData$5(buffer, (EntityPlayer)player));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$onPacketData$5(ByteBuf buffer, EntityPlayer player) {
        EnumPacketClient type = null;
        try {
            type = EnumPacketClient.values()[buffer.readInt()];
            CustomNpcs.debugData.start(null, type.toString());
            if (!list.contains((Object)type)) {
                LogWriter.debug("Received: " + (Object)((Object)type));
            }
            this.client(buffer, player, type);
            CustomNpcs.debugData.end(null, type.toString());
        }
        catch (Exception e) {
            LogWriter.error("Error with EnumPacketClient." + (Object)((Object)type), e);
        }
        finally {
            buffer.release();
        }
    }

    static {
        list.add(EnumPacketClient.EYE_BLINK);
        list.add(EnumPacketClient.NPC_VISUAL_DATA);
        list.add(EnumPacketClient.UPDATE_NPC);
        list.add(EnumPacketClient.SET_TILE_DATA);
        list.add(EnumPacketClient.SEND_FILE_LIST);
        list.add(EnumPacketClient.SEND_FILE_PART);
        list.add(EnumPacketClient.PLAY_SOUND);
        list.add(EnumPacketClient.NPC_MOVING_PATH);
        list.add(EnumPacketClient.UPDATE_NPC_ANIMATION);
        list.add(EnumPacketClient.UPDATE_NPC_NAVIGATION);
        list.add(EnumPacketClient.UPDATE_NPC_AI_TARGET);
        list.add(EnumPacketClient.UPDATE_NPC_TARGET);
        list.add(EnumPacketClient.CHAT_BUBBLE);
        list.add(EnumPacketClient.SYNC_ADD);
        list.add(EnumPacketClient.SYNC_END);
        list.add(EnumPacketClient.SYNC_UPDATE);
        list.add(EnumPacketClient.BORDER_DATA);
        list.add(EnumPacketClient.MARCET_DATA);
        list.add(EnumPacketClient.VISIBLE_TRUE);
        list.add(EnumPacketClient.VISIBLE_FALSE);
        list.add(EnumPacketClient.NPC_DATA);
        list.add(EnumPacketClient.FORCE_PLAY_SOUND);
        list.add(EnumPacketClient.PLAYER_SKIN_ADD);
        list.add(EnumPacketClient.NPC_LOOK_POS);
        list.add(EnumPacketClient.UPDATE_HUD);
        list.add(EnumPacketClient.ANIMATION_DATA_SET);
        list.add(EnumPacketClient.ANIMATION_DATA_BASE_ANIMATIONS);
        list.add(EnumPacketClient.ANIMATION_DATA_RUN_ANIMATION);
        list.add(EnumPacketClient.ANIMATION_DATA_STOP_ANIMATION);
        list.add(EnumPacketClient.ANIMATION_DATA_STOP_EMOTION);
        list.add(EnumPacketClient.GUI);
        list.add(EnumPacketClient.GUI_DATA);
        list.add(EnumPacketClient.SCROLL_DATA);
        list.add(EnumPacketClient.SCROLL_SELECTED);
        list.add(EnumPacketClient.EDIT_NPC);
    }

    public static class TempWaypointText {
        public String text;
        String endText;

        public TempWaypointText(String t, String e) {
            this.text = t;
            this.endText = e;
        }

        public String getString() {
            return this.text + this.endText;
        }
    }
}

